/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.ponder.scenes;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class ArmScenes {
    public static void setup(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_arm", "Setting up Mechanical Arms");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        class_1799 armItem = AllBlocks.MECHANICAL_ARM.asStack();
        class_2338 armPos = util.grid().at(2, 1, 2);
        Selection armSel = util.select().position(armPos);
        class_2338 inputDepot = util.grid().at(4, 2, 1);
        class_243 depotSurface = util.vector().blockSurface(inputDepot, class_2350.field_11043);
        class_243 armSurface = util.vector().blockSurface(armPos, class_2350.field_11039);
        scene.idle(20);
        scene.world().setKineticSpeed(armSel, 0.0f);
        scene.world().showSection(armSel, class_2350.field_11033);
        scene.idle(10);
        scene.effects().indicateRedstone(armPos);
        scene.overlay().showOutlineWithText(armSel, 70).attachKeyFrame().colored(PonderPalette.RED).text("Mechanical Arms have to be assigned their in- and outputs before they are placed").pointAt(armSurface).placeNearTarget();
        scene.idle(80);
        scene.world().showSection(util.select().fromTo(4, 1, 1, 4, 2, 1), class_2350.field_11033);
        scene.world().showSection(util.select().fromTo(0, 1, 1, 0, 2, 1), class_2350.field_11033);
        scene.world().hideSection(armSel, class_2350.field_11036);
        scene.idle(20);
        scene.overlay().showControls(depotSurface, Pointing.RIGHT, 50).rightClick().withItem(armItem);
        scene.idle(7);
        class_238 depotBounds = AllShapes.CASING_13PX.get(class_2350.field_11036).method_1107();
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), depotBounds.method_989(4.0, 2.0, 1.0), 400);
        scene.overlay().showText(70).attachKeyFrame().colored(PonderPalette.INPUT).text("Right-Click inventories while holding the Arm to assign them as Targets").pointAt(util.vector().blockSurface(inputDepot, class_2350.field_11039)).placeNearTarget();
        scene.idle(80);
        class_2338 outputDepot = util.grid().at(0, 2, 1);
        scene.overlay().showControls(util.vector().blockSurface(outputDepot, class_2350.field_11043), Pointing.RIGHT, 20).rightClick().withItem(armItem);
        scene.idle(7);
        Object second = new Object();
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, second, depotBounds.method_989(0.0, 2.0, 1.0), 100);
        scene.idle(25);
        scene.overlay().showControls(util.vector().blockSurface(outputDepot, class_2350.field_11043), Pointing.RIGHT, 30).rightClick().withItem(armItem);
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, second, depotBounds.method_989(0.0, 2.0, 1.0), 280);
        scene.overlay().showText(70).colored(PonderPalette.OUTPUT).text("Right-Click again to toggle between Input (Blue) and Output (Yellow)").pointAt(util.vector().blockSurface(outputDepot, class_2350.field_11039)).placeNearTarget();
        scene.idle(80);
        scene.world().showSection(util.select().position(1, 1, 0), class_2350.field_11033);
        scene.idle(15);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), depotBounds.method_989(1.0, 1.0, 0.0), 43);
        scene.overlay().showText(50).colored(PonderPalette.WHITE).text("Left-Click components to remove their Selection").pointAt(util.vector().blockSurface(util.grid().at(1, 1, 0), class_2350.field_11039)).placeNearTarget();
        scene.idle(35);
        scene.overlay().showControls(util.vector().topOf(util.grid().at(1, 1, 0)), Pointing.DOWN, 30).leftClick().withItem(armItem);
        scene.idle(50);
        scene.world().showSection(armSel, class_2350.field_11033);
        scene.idle(10);
        class_243 armTop = armSurface.method_1031(0.5, 1.5, 0.0);
        scene.overlay().showText(70).attachKeyFrame().colored(PonderPalette.GREEN).text("Once placed, the Mechanical Arm will target the blocks selected previously").pointAt(armTop).placeNearTarget();
        scene.idle(80);
        scene.effects().indicateSuccess(armPos);
        scene.world().showSection(util.select().fromTo(2, 1, 5, 2, 1, 3).add(util.select().position(2, 0, 5)), class_2350.field_11033);
        class_1799 copper = new class_1799((class_1935)class_1802.field_27022);
        scene.world().createItemOnBeltLike(inputDepot, class_2350.field_11035, copper);
        scene.idle(10);
        scene.world().setKineticSpeed(armSel, -48.0f);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, class_1799.field_8037, 1);
        scene.idle(24);
        scene.world().removeItemsFromBelt(inputDepot);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, copper, -1);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, copper, 1);
        scene.idle(24);
        scene.world().createItemOnBeltLike(outputDepot, class_2350.field_11036, copper);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_INPUTS, class_1799.field_8037, -1);
        scene.idle(44);
        scene.world().showSection(util.select().fromTo(1, 1, 4, 1, 3, 4), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(4, 1, 2), class_2350.field_11033);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, new Object(), depotBounds.method_989(0.0, 2.0, 1.0), 60);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), depotBounds.method_989(4.0, 2.0, 1.0), 60);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, new Object(), depotBounds.method_989(1.0, 1.0, 0.0), 60);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), depotBounds.method_989(1.0, 3.0, 4.0), 60);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), depotBounds.method_989(4.0, 1.0, 2.0), 60);
        scene.idle(5);
        scene.overlay().showText(80).attachKeyFrame().text("They can have any amount of in- and outputs within their range").pointAt(util.vector().blockSurface(util.grid().at(1, 3, 4), class_2350.field_11039)).placeNearTarget();
        inputDepot = util.grid().at(1, 3, 4);
        outputDepot = util.grid().at(1, 1, 0);
        copper = new class_1799((class_1935)class_1802.field_27071);
        scene.world().createItemOnBeltLike(inputDepot, class_2350.field_11035, copper);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, class_1799.field_8037, 2);
        scene.idle(24);
        scene.world().removeItemsFromBelt(inputDepot);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, copper, -1);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, copper, 0);
        scene.idle(24);
        scene.world().createItemOnBeltLike(outputDepot, class_2350.field_11036, copper);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_INPUTS, class_1799.field_8037, -1);
        scene.world().hideSection(util.select().fromTo(4, 2, 1, 4, 1, 1), class_2350.field_11036);
        scene.idle(2);
        scene.world().hideSection(util.select().fromTo(1, 1, 4, 1, 3, 4), class_2350.field_11036);
        scene.idle(5);
        scene.world().hideSection(util.select().fromTo(0, 1, 1, 0, 2, 1), class_2350.field_11036);
        scene.idle(2);
        scene.world().hideSection(util.select().position(1, 1, 0), class_2350.field_11036);
        scene.idle(5);
        scene.world().hideSection(util.select().position(4, 1, 2), class_2350.field_11036);
        scene.idle(15);
        scene.world().showSection(util.select().fromTo(4, 1, 3, 4, 2, 3), class_2350.field_11043);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(0, 1, 3, 0, 2, 3), class_2350.field_11043);
        scene.idle(15);
        Object in = new Object();
        Object out = new Object();
        class_238 chestBounds = new class_238(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
        class_238 funnelBounds = new class_238(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, in, chestBounds.method_989(4.0, 2.0, 3.0), 120);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, out, chestBounds.method_989(0.0, 2.0, 3.0), 120);
        scene.overlay().showText(80).attachKeyFrame().text("However, not every type of Inventory can be interacted with directly").colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(0, 2, 3), class_2350.field_11039));
        scene.idle(90);
        scene.world().showSection(util.select().fromTo(4, 1, 2, 4, 2, 2), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().position(0, 2, 2), class_2350.field_11035);
        scene.idle(10);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, in, depotBounds.method_989(4.0, 1.0, 2.0), 80);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, funnelBounds.method_989(0.0, 2.0, 2.0), 80);
        scene.idle(5);
        scene.overlay().showText(60).text("Funnels and Depots can help to Bridge that gap").colored(PonderPalette.OUTPUT).placeNearTarget().pointAt(util.vector().topOf(util.grid().at(0, 2, 2)).method_1031(0.0, 0.0, 0.25));
        scene.idle(70);
        class_1799 sword = new class_1799((class_1935)class_1802.field_8845);
        inputDepot = util.grid().at(4, 1, 2);
        scene.overlay().showControls(util.vector().topOf(inputDepot), Pointing.RIGHT, 30).withItem(sword);
        scene.world().createItemOnBeltLike(inputDepot, class_2350.field_11035, sword);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, class_1799.field_8037, 0);
        scene.idle(24);
        scene.world().removeItemsFromBelt(inputDepot);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, sword, -1);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, sword, 2);
        scene.idle(24);
        scene.world().flapFunnel(util.grid().at(0, 2, 2), false);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_INPUTS, class_1799.field_8037, -1);
        scene.idle(5);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(0, 2, 3), class_2350.field_11039), Pointing.LEFT, 30).withItem(sword);
    }

    public static void filtering(SceneBuilder builder, SceneBuildingUtil util) {
        class_2338 funnelPos;
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_arm_filtering", "Filtering Outputs of the Mechanical Arm");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.9f);
        scene.world().setKineticSpeed(util.select().fromTo(4, 1, 4, 6, 0, 5), 0.0f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(4, 1, 4, 5, 1, 5), class_2350.field_11033);
        scene.idle(10);
        for (int x = 0; x < 2; ++x) {
            scene.idle(3);
            scene.world().showSection(util.select().position(x + 1, 1, 4), class_2350.field_11033);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                scene.world().showSection(util.select().position(y == 1 ? x + 3 : 5 - x, y + 1, 1), class_2350.field_11033);
                scene.idle(2);
            }
        }
        scene.world().showSection(util.select().position(6, 1, 1), class_2350.field_11039);
        scene.world().showSection(util.select().position(2, 1, 1), class_2350.field_11034);
        class_1799 sand = new class_1799((class_1935)class_1802.field_8858, 64);
        class_1799 sulphur = new class_1799((class_1935)class_1802.field_8054, 64);
        scene.world().createItemOnBeltLike(util.grid().at(2, 1, 4), class_2350.field_11035, sand);
        scene.world().createItemOnBeltLike(util.grid().at(1, 1, 4), class_2350.field_11035, sulphur);
        scene.overlay().showOutlineWithText(util.select().fromTo(2, 1, 4, 1, 1, 4), 60).text("Inputs").placeNearTarget().colored(PonderPalette.INPUT);
        scene.idle(50);
        scene.overlay().showOutlineWithText(util.select().fromTo(5, 3, 1, 3, 1, 1), 40).text("Outputs").placeNearTarget().colored(PonderPalette.OUTPUT);
        scene.idle(50);
        scene.overlay().showText(80).attachKeyFrame().text("Sometimes it is desirable to restrict targets of the Arm by matching a filter").placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 3, 1), class_2350.field_11039));
        scene.idle(90);
        scene.rotateCameraY(-120.0f);
        scene.idle(20);
        scene.overlay().showOutlineWithText(util.select().position(4, 1, 4), 80).colored(PonderPalette.RED).text("Mechanical Arms by themselves do not provide any options for filtering").placeNearTarget();
        scene.idle(90);
        for (int y = 0; y < 3; ++y) {
            scene.world().showSection(util.select().fromTo(5, y + 1, 2, 3, y + 1, 2), class_2350.field_11043);
            scene.idle(2);
        }
        class_243 filterSlot = util.vector().of(3.5, 3.75, 2.6);
        scene.overlay().showFilterSlotInput(filterSlot, class_2350.field_11043, 80);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.GREEN).pointAt(filterSlot).text("Brass Funnels as Targets do however communicate their own filter to the Arm").placeNearTarget();
        scene.idle(90);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                class_1799 item = (x + y) % 2 == 0 ? sulphur : sand;
                scene.overlay().showControls(filterSlot.method_1031((double)(2 - x), (double)(-y), 0.0), Pointing.LEFT, 5).rightClick().withItem(item);
                scene.idle(7);
                scene.world().setFilterData(util.select().position(5 - x, 3 - y, 2), FunnelBlockEntity.class, item);
                scene.idle(4);
            }
        }
        scene.world().setKineticSpeed(util.select().fromTo(4, 1, 4, 6, 0, 5), 24.0f);
        scene.world().multiplyKineticSpeed(util.select().position(5, 1, 5), -1.0f);
        scene.world().multiplyKineticSpeed(util.select().position(4, 1, 4), 2.0f);
        scene.idle(10);
        class_2338 armPos = util.grid().at(4, 1, 4);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, class_1799.field_8037, 1);
        scene.idle(24);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, sand, -1);
        scene.idle(20);
        scene.overlay().showText(80).attachKeyFrame().pointAt(util.vector().topOf(2, 1, 4)).text("The Arm is smart enough not to pick up items it couldn't distribute").placeNearTarget();
        scene.idle(90);
        for (i = 0; i < 4; ++i) {
            int index = i * 2 + 1;
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, sand, index);
            scene.idle(24);
            funnelPos = util.grid().at(5 - index % 3, 1 + index / 3, 2);
            scene.world().flapFunnel(funnelPos, false);
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_INPUTS, i == 3 ? class_1799.field_8037 : sand, -1);
            scene.world().modifyBlockEntity(funnelPos.method_10095(), MechanicalCrafterBlockEntity.class, mct -> TransferUtil.insert((Storage)mct.getInventory(), (Object)ItemVariant.of((class_1799)sand), (long)sand.method_7947()));
            scene.idle(10);
        }
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, class_1799.field_8037, 0);
        scene.idle(24);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, sulphur, -1);
        scene.idle(20);
        scene.rotateCameraY(120.0f);
        scene.world().setCraftingResult(util.grid().at(3, 1, 1), new class_1799((class_1935)class_2246.field_10375));
        for (i = 0; i < 5; ++i) {
            int index = i * 2;
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, sulphur, index);
            scene.idle(24);
            funnelPos = util.grid().at(3 + index % 3, 1 + index / 3, 2);
            scene.world().flapFunnel(funnelPos, false);
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_INPUTS, i == 4 ? class_1799.field_8037 : sulphur, -1);
            scene.world().modifyBlockEntity(funnelPos.method_10095(), MechanicalCrafterBlockEntity.class, mct -> TransferUtil.insert((Storage)mct.getInventory(), (Object)ItemVariant.of((class_1799)sulphur), (long)sulphur.method_7947()));
            scene.idle(10);
        }
        scene.idle(120);
    }

    public static void modes(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_arm_modes", "Distribution modes of the Mechanical Arm");
        scene.configureBasePlate(0, 1, 5);
        scene.world().setBlock(util.grid().at(3, 1, 0), class_2246.field_10499.method_9564(), false);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 4, 4, 1, 5), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 4, 1, 2, 5), class_2350.field_11043);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 1, 5, 1, 2), class_2350.field_11035);
        scene.idle(10);
        class_238 depotBox = AllShapes.CASING_13PX.get(class_2350.field_11036).method_1107();
        class_238 beltBox = depotBox.method_1002(0.0, -0.1875, 0.0).method_1009(1.0, 0.0, 0.0);
        class_2338 depotPos = util.grid().at(1, 1, 4);
        class_2338 armPos = util.grid().at(3, 1, 4);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, (Object)depotBox, depotBox.method_989(1.0, 1.0, 4.0), 60);
        scene.overlay().showText(30).text("Input").pointAt(util.vector().blockSurface(depotPos, class_2350.field_11039)).placeNearTarget().colored(PonderPalette.INPUT);
        scene.idle(40);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)depotBox, beltBox.method_989(2.0, 1.0, 2.0), 40);
        scene.overlay().showText(40).text("Outputs").pointAt(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11039)).placeNearTarget().colored(PonderPalette.OUTPUT);
        scene.idle(50);
        class_1799 item = new class_1799((class_1935)class_1802.field_8543);
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11035, item);
        scene.overlay().showText(60).attachKeyFrame().text("Whenever an Arm has to choose between multiple valid outputs...").pointAt(util.vector().blockSurface(util.grid().at(2, 1, 2), class_2350.field_11036)).placeNearTarget().colored(PonderPalette.OUTPUT);
        scene.idle(70);
        class_243 scrollSlot = util.vector().of(3.5, 1.1875, 4.0);
        scene.overlay().showFilterSlotInput(scrollSlot, class_2350.field_11043, 120);
        scene.overlay().showText(50).text("...it will act according to its setting").pointAt(scrollSlot).placeNearTarget();
        scene.idle(60);
        scene.overlay().showControls(scrollSlot, Pointing.RIGHT, 40).rightClick();
        scene.idle(10);
        scene.overlay().showText(50).text("The value panel will allow you to configure it").pointAt(scrollSlot).placeNearTarget();
        scene.idle(60);
        ElementLink blockage = scene.world().showIndependentSection(util.select().position(4, 1, 0), class_2350.field_11036);
        scene.world().moveSection(blockage, util.vector().of(-1.0, 0.0, 0.0), 0);
        for (int i = 0; i < 20; ++i) {
            if (i == 2) {
                scene.overlay().showText(60).attachKeyFrame().text("Round Robin mode simply cycles through all outputs that are available").pointAt(util.vector().blockSurface(util.grid().at(2, 1, 2), class_2350.field_11036)).placeNearTarget().colored(PonderPalette.OUTPUT);
            }
            if (i == 6) continue;
            if (i == 7) {
                scene.overlay().showText(60).attachKeyFrame().text("If an output is unable to take more items, it will be skipped").pointAt(util.vector().blockSurface(util.grid().at(3, 1, 2), class_2350.field_11036)).placeNearTarget().colored(PonderPalette.GREEN);
            }
            if (i == 12) {
                scene.world().moveSection(blockage, util.vector().of(-1.0, 0.0, 0.0), 10);
                scene.world().setBlock(util.grid().at(3, 1, 0), class_2246.field_10499.method_9564(), false);
            }
            int index = i % 3;
            if (i == 13) {
                scene.world().setBlock(util.grid().at(2, 1, 0), class_2246.field_10499.method_9564(), false);
                ElementLink blockage2 = scene.world().showIndependentSection(util.select().position(4, 1, 0), class_2350.field_11036);
                scene.world().moveSection(blockage2, util.vector().of(-2.0, 0.0, 0.0), 0);
                scene.overlay().showText(60).attachKeyFrame().text("Prefer First prioritizes the outputs selected earliest when configuring this Arm").pointAt(util.vector().blockSurface(util.grid().at(3, 1, 2), class_2350.field_11036)).placeNearTarget().colored(PonderPalette.GREEN);
                index = 0;
            }
            if (i == 14) {
                index = 1;
            }
            if (i == 15) {
                index = 1;
            }
            if (i >= 16) {
                index = 2;
            }
            scene.idle(5);
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, class_1799.field_8037, 0);
            scene.idle(12);
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, item, -1);
            scene.world().removeItemsFromBelt(depotPos);
            scene.idle(5);
            if (i == 9) {
                scene.overlay().showText(80).attachKeyFrame().text("Forced Round Robin mode will never skip outputs, and instead wait until they are free").pointAt(util.vector().blockSurface(util.grid().at(3, 1, 2), class_2350.field_11036)).placeNearTarget().colored(PonderPalette.RED);
                scene.idle(40);
                scene.world().moveSection(blockage, util.vector().of(1.0, 0.0, 0.0), 10);
                scene.world().setBlock(util.grid().at(3, 1, 0), class_2246.field_10124.method_9564(), false);
                scene.idle(50);
                scene.world().multiplyKineticSpeed(util.select().fromTo(1, 1, 1, 5, 0, 3), 2.0f);
            }
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, item, index);
            scene.world().createItemOnBeltLike(depotPos, class_2350.field_11035, item);
            scene.idle(12);
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_INPUTS, class_1799.field_8037, -1);
            scene.world().createItemOnBelt(util.grid().at(3 - index, 1, 2), class_2350.field_11036, item);
        }
    }

    public static void redstone(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_arm_redstone", "Controlling Mechanical Arms with Redstone");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 3, 2, 1, 4), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 5, 4, 1, 3), class_2350.field_11039);
        scene.idle(5);
        scene.world().showSection(util.select().position(4, 1, 2), class_2350.field_11035);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(2, 1, 1, 4, 1, 1), class_2350.field_11034);
        scene.idle(10);
        Selection redstone = util.select().fromTo(1, 1, 0, 1, 1, 2);
        scene.world().showSection(redstone, class_2350.field_11035);
        class_2338 armPos = util.grid().at(1, 1, 3);
        class_2338 leverPos = util.grid().at(1, 1, 0);
        class_1799 item = new class_1799((class_1935)class_1802.field_8604);
        scene.world().createItemOnBeltLike(util.grid().at(4, 1, 1), class_2350.field_11035, item);
        for (int i = 0; i < 3; ++i) {
            scene.idle(12);
            if (i == 1) {
                scene.world().toggleRedstonePower(redstone);
                scene.effects().indicateRedstone(leverPos);
                scene.idle(10);
                scene.overlay().showText(60).colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector().topOf(armPos)).placeNearTarget().text("When powered by Redstone, Mechanical Arms will not activate");
                scene.idle(70);
                scene.world().toggleRedstonePower(redstone);
            }
            if (i == 2) {
                scene.idle(60);
                scene.world().toggleRedstonePower(redstone);
                scene.idle(3);
                scene.world().toggleRedstonePower(redstone);
                scene.effects().indicateRedstone(leverPos);
            }
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, class_1799.field_8037, 0);
            scene.idle(18);
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, item, -1);
            scene.world().removeItemsFromBelt(util.grid().at(3, 1, 1));
            scene.idle(5);
            if (i == 1) {
                scene.world().toggleRedstonePower(redstone);
                scene.effects().indicateRedstone(leverPos);
                scene.overlay().showText(60).pointAt(util.vector().topOf(armPos)).placeNearTarget().text("Before stopping, it will finish any started cycles");
            }
            scene.idle(10);
            if (i == 2) {
                scene.overlay().showText(100).colored(PonderPalette.GREEN).attachKeyFrame().pointAt(util.vector().topOf(armPos)).placeNearTarget().text("Thus, a negative pulse can be used to trigger exactly one activation cycle");
            }
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, item, 0);
            scene.world().createItemOnBeltLike(util.grid().at(4, 1, 1), class_2350.field_11035, item);
            scene.idle(18);
            scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_INPUTS, class_1799.field_8037, -1);
            scene.world().createItemOnBelt(util.grid().at(3, 1, 3), class_2350.field_11036, item);
        }
        scene.idle(5);
    }
}

